/*
 * Decompiled with CFR 0.152.
 */
package net.salju.kobolds.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.GlowSquid;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.PlayMessages;
import net.salju.kobolds.entity.KoboldCaptainEntity;
import net.salju.kobolds.entity.KoboldEngineerEntity;
import net.salju.kobolds.entity.KoboldEntity;
import net.salju.kobolds.entity.KoboldPirateEntity;
import net.salju.kobolds.entity.KoboldWarriorEntity;
import net.salju.kobolds.init.KoboldsModEntities;

public class KoboldZombieDrownedEntity
extends Drowned {
    private static final EntityDataAccessor<Boolean> DATA_CONVERTING = SynchedEntityData.m_135353_(KoboldZombieDrownedEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public KoboldZombieDrownedEntity(PlayMessages.SpawnEntity packet, Level world) {
        this((EntityType<KoboldZombieDrownedEntity>)((EntityType)KoboldsModEntities.KOBOLD_ZOMBIE_DROWNED.get()), world);
    }

    public KoboldZombieDrownedEntity(EntityType<KoboldZombieDrownedEntity> type, Level world) {
        super(type, world);
        this.m_20299_(0.5f);
        this.m_21553_(true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CONVERTING, (Object)false);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, GlowSquid.class, true, false));
    }

    public double m_6049_() {
        return this.m_6162_() ? 0.0 : -0.225;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return this.m_6162_() ? 0.66f : 1.26f;
    }

    protected boolean m_7593_() {
        return false;
    }

    public boolean m_6162_() {
        return false;
    }

    public boolean isConvert() {
        return (Boolean)this.m_20088_().m_135370_(DATA_CONVERTING);
    }

    public static void init() {
        SpawnPlacements.m_21754_((EntityType)((EntityType)KoboldsModEntities.KOBOLD_ZOMBIE_DROWNED.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (entityType, world, reason, pos, random) -> world.m_46791_() != Difficulty.PEACEFUL && Monster.m_219009_((ServerLevelAccessor)world, (BlockPos)pos, (RandomSource)random) && Mob.m_217057_((EntityType)entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random));
    }

    public void m_6075_() {
        super.m_6075_();
        Level world = this.f_19853_;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        if (!this.f_19853_.m_5776_() && this.m_6084_() && !this.m_21525_()) {
            if (this.getPersistentData().m_128459_("Convert") > 1.0) {
                this.getPersistentData().m_128347_("Convert", this.getPersistentData().m_128459_("Convert") - 1.0);
            } else if (this.getPersistentData().m_128459_("Convert") == 1.0 && this.m_6084_()) {
                this.m_5496_(SoundEvents.f_12616_, 1.0f, 1.0f);
                ItemStack weapon = this.m_21205_();
                ItemStack off = this.m_21206_();
                if (world instanceof ServerLevel) {
                    ServerLevel lvl = (ServerLevel)world;
                    if (world.m_204166_(new BlockPos(x, y, z)).m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("minecraft:is_jungle")))) {
                        if (weapon.m_41720_() instanceof SwordItem && weapon.m_41793_()) {
                            KoboldCaptainEntity capty = (KoboldCaptainEntity)this.m_21406_((EntityType)KoboldsModEntities.KOBOLD_CAPTAIN.get(), true);
                            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)capty);
                        } else {
                            KoboldPirateEntity pirate = (KoboldPirateEntity)this.m_21406_((EntityType)KoboldsModEntities.KOBOLD_PIRATE.get(), true);
                            ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)pirate);
                        }
                    } else if (world.m_204166_(new BlockPos(x, y, z)).m_203656_(TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation("minecraft:is_mountain"))) && weapon.m_41720_() == Items.f_42717_ && off == ItemStack.f_41583_) {
                        KoboldEngineerEntity engi = (KoboldEngineerEntity)this.m_21406_((EntityType)KoboldsModEntities.KOBOLD_ENGINEER.get(), true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)engi);
                    } else if (off.m_41720_() instanceof ShieldItem) {
                        KoboldWarriorEntity war = (KoboldWarriorEntity)this.m_21406_((EntityType)KoboldsModEntities.KOBOLD_WARRIOR.get(), true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)war);
                    } else {
                        KoboldEntity basic = (KoboldEntity)this.m_21406_((EntityType)KoboldsModEntities.KOBOLD.get(), true);
                        ForgeEventFactory.onLivingConvert((LivingEntity)this, (LivingEntity)basic);
                    }
                }
            }
        }
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        super.m_6071_(player, hand);
        ItemStack apple = player.m_21120_(hand);
        Level world = this.f_19853_;
        double x = this.m_20185_();
        double y = this.m_20186_();
        double z = this.m_20189_();
        double waitTicks = 0.0;
        double potionLevel = 0.0;
        if (!this.f_19853_.m_5776_() && apple.m_41720_() == Items.f_42436_ && this.m_21023_(MobEffects.f_19613_)) {
            if (world.m_46791_() == Difficulty.EASY) {
                potionLevel = 0.0;
                waitTicks = 1200.0;
            } else if (world.m_46791_() == Difficulty.NORMAL) {
                potionLevel = 0.0;
                waitTicks = 2400.0;
            } else if (world.m_46791_() == Difficulty.HARD) {
                potionLevel = 1.0;
                waitTicks = 4800.0;
            }
            if (!player.m_150110_().f_35937_) {
                apple.m_41774_(1);
            }
            player.m_21011_(hand, true);
            this.m_5496_(SoundEvents.f_12644_, 1.0f, 1.0f);
            this.m_21195_(MobEffects.f_19613_);
            this.m_7292_(new MobEffectInstance(MobEffects.f_19600_, (int)waitTicks, (int)potionLevel));
            this.getPersistentData().m_128347_("Convert", waitTicks);
            this.m_20088_().m_135381_(DATA_CONVERTING, (Object)true);
        }
        return InteractionResult.FAIL;
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.m_21552_();
        builder = builder.m_22268_(Attributes.f_22279_, 0.2);
        builder = builder.m_22268_(Attributes.f_22276_, 18.0);
        builder = builder.m_22268_(Attributes.f_22284_, 2.0);
        builder = builder.m_22268_(Attributes.f_22281_, 3.0);
        builder = builder.m_22266_(Attributes.f_22287_);
        return builder;
    }
}

